' Rectangle.vb - Definiuje kilka metod wspdzielonych, rysujcych prostokty
' Copyright (c) 2001. All Rights Reserved.
' By Paul Kimmel. pkimmel@softconcepts.com

Imports System.Drawing

Public Class Rects

  Public Shared Function RandomRectangle(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Rectangle

    If (Index Mod 3 = 0) Then
      Return RectangleSector(Rect, Index, Index / 2, Segments)
    ElseIf (Index Mod 2 = 0) Then
      Return VerticalRectangle(Rect, Index, Segments)
    Else
      Return HorizontalRectangle(Rect, Index, Segments)
    End If

  End Function

  Public Shared Function RectangleSector(ByVal Rect As Rectangle, _
    ByVal X As Integer, ByVal Y As Integer, ByVal Segments As Integer) As Rectangle

    Dim R As Rectangle
    R = VerticalRectangle(Rect, Y, Segments)
    R = HorizontalRectangle(R, X, Segments)
    Return R

  End Function

  Public Shared Function VerticalRectangle(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Rectangle

    Return New Rectangle(Rect.Left, NewTop(Rect, Index, Segments), _
      Rect.Width, NewBottom(Rect, Index, Segments))

  End Function

  Public Shared Function HorizontalRectangle(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Rectangle

    Return New Rectangle(NewLeft(Rect, Index, Segments), Rect.Top, _
      NewRight(Rect, Index, Segments), Rect.Bottom)

  End Function

  Public Shared Function NewTop(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Integer

    Return (Rect.Top + (Index / Segments) * Rect.Height)

  End Function

  Public Shared Function NewBottom(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Integer

    Return NewTop(Rect, Index, Segments) + (Rect.Height / Segments)

  End Function

  Public Shared Function NewLeft(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Integer

    Return Rect.Left + (Index / Segments) * Rect.Width

  End Function

  Public Shared Function NewRight(ByVal Rect As Rectangle, _
    ByVal Index As Integer, ByVal Segments As Integer) As Integer

    Return NewLeft(Rect, Index, Segments) + Rect.Width / Segments

  End Function


End Class
